/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import jclass.bwt.JCButton;
import jclass.util.JCImageCreator;

public class DateTimeEntry
extends Panel
implements MouseListener,
TextListener,
FocusListener {
    private TextField dateEntryField = new TextField(20);
    private TextField timeEntryField = new TextField(12);
    private JCButton dateButton;
    private JCButton timeButton;
    private DateFormat dateFormatter = DateFormat.getDateInstance(1);
    private DateFormat timeFormatter = DateFormat.getTimeInstance(3);
    private Date selectedDate;
    private boolean dateHasChanged = false;
    private boolean timeHasChanged = false;
    private static final long MS_IN_DAY = 86400000L;
    private static final long MS_IN_HOUR = 3600000L;
    private static final long MS_IN_MINUTE = 60000L;
    static final String[] button_pixels = new String[]{"             r             ", "             r     rr      ", "             r    rrrr     ", "     rr      r   rr  rr    ", "    rrrr     r  rr    rr   ", "   rr  rr    r rr  rr  rr  ", "  rr    rr   r    rrrr     ", " rr      rr  r   rr  rr    ", "             r  rr    rr   ", "             r rr      rr  ", "             r             ", "             r             ", "rrrrrrrrrrrrrrrrrrrrrrrrrrr", "             r             ", "             r             ", "             r rr      rr  ", "             r  rr    rr   ", " rr      rr  r   rr  rr    ", "  rr    rr   r    rrrr     ", "   rr  rr    r rr  rr  rr  ", "    rrrr     r  rr    rr   ", "     rr      r   rr  rr    ", "             r    rrrr     ", "             r     rr      ", "             r             "};

    public DateTimeEntry() {
        this(new Date());
    }

    public DateTimeEntry(Date date) {
        super(new FlowLayout(0, 0, 5));
        this.initialize();
        long l = date.getTime();
        l /= 60000L;
        this.selectedDate = new Date(l *= 60000L);
        ((TextComponent)this.dateEntryField).setText(this.dateFormatter.format(this.selectedDate));
        ((TextComponent)this.timeEntryField).setText(this.timeFormatter.format(this.selectedDate));
    }

    protected void initialize() {
        JCImageCreator jCImageCreator = new JCImageCreator(this, button_pixels[0].length(), button_pixels.length);
        jCImageCreator.setColor('r', Color.black);
        Image image = jCImageCreator.create(button_pixels);
        this.dateButton = new JCButton(image);
        this.timeButton = new JCButton(image);
        this.dateFormatter.setTimeZone(TimeZone.getDefault());
        this.timeFormatter.setTimeZone(TimeZone.getDefault());
        this.add(this.dateEntryField);
        this.add(this.dateButton);
        Canvas canvas = new Canvas();
        canvas.setSize(10, 20);
        this.add(canvas);
        this.add(this.timeEntryField);
        this.add(this.timeButton);
        this.dateButton.addMouseListener(this);
        this.timeButton.addMouseListener(this);
        this.dateEntryField.addFocusListener(this);
        this.timeEntryField.addFocusListener(this);
    }

    public void setEnabled(boolean bl) {
        this.dateEntryField.setEnabled(bl);
        this.timeEntryField.setEnabled(bl);
        super.setEnabled(bl);
    }

    public Date getDate() {
        if (this.timeHasChanged) {
            this.readAndFormatTime();
        }
        if (this.dateHasChanged) {
            this.readAndFormatDate();
        }
        return this.selectedDate;
    }

    protected void formatDate() {
        ((TextComponent)this.dateEntryField).setText(this.dateFormatter.format(this.selectedDate));
        ((TextComponent)this.timeEntryField).setText(this.timeFormatter.format(this.selectedDate));
    }

    protected boolean readAndFormatDate() {
        boolean bl = true;
        try {
            Date date = this.dateFormatter.parse(this.dateEntryField.getText());
            long l = this.selectedDate.getTime() % 86400000L;
            long l2 = date.getTime() - date.getTime() % 86400000L;
            this.selectedDate.setTime(l2 + l);
        }
        catch (Exception exception) {
            ((TextComponent)this.dateEntryField).setText(this.dateFormatter.format(this.selectedDate));
            bl = false;
        }
        this.dateHasChanged = false;
        return bl;
    }

    protected boolean readAndFormatTime() {
        boolean bl = true;
        try {
            Date date = this.timeFormatter.parse(this.timeEntryField.getText());
            long l = this.selectedDate.getTime() - this.selectedDate.getTime() % 86400000L;
            this.selectedDate.setTime(l + date.getTime());
        }
        catch (Exception exception) {
            ((TextComponent)this.timeEntryField).setText(this.timeFormatter.format(this.selectedDate));
            bl = false;
        }
        this.timeHasChanged = false;
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        long l = 0L;
        if (mouseEvent.getComponent() == this.timeButton) {
            l = mouseEvent.getY() < 17 ? (mouseEvent.getX() < 21 ? 60000L : 3600000L) : (mouseEvent.getX() < 21 ? -60000L : -3600000L);
            if (this.timeHasChanged) {
                this.readAndFormatTime();
            }
            this.selectedDate.setTime(this.selectedDate.getTime() + l);
            ((TextComponent)this.timeEntryField).setText(this.timeFormatter.format(this.selectedDate));
            return;
        }
        if (mouseEvent.getComponent() == this.dateButton) {
            l = mouseEvent.getY() < 17 ? (mouseEvent.getX() < 21 ? 86400000L : 2592000000L) : (mouseEvent.getX() < 21 ? -86400000L : -2592000000L);
            if (this.dateHasChanged) {
                this.readAndFormatDate();
            }
            this.selectedDate.setTime(this.selectedDate.getTime() + l);
            ((TextComponent)this.dateEntryField).setText(this.dateFormatter.format(this.selectedDate));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.dateEntryField) {
            this.dateHasChanged = true;
            return;
        }
        if (textEvent.getSource() == this.timeEntryField) {
            this.timeHasChanged = true;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.dateEntryField) {
            this.dateEntryField.addTextListener(this);
            return;
        }
        if (focusEvent.getSource() == this.timeEntryField) {
            this.timeEntryField.addTextListener(this);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.dateEntryField) {
            this.dateEntryField.removeTextListener(this);
            if (this.dateHasChanged) {
                this.readAndFormatDate();
                return;
            }
        } else if (focusEvent.getSource() == this.timeEntryField) {
            this.timeEntryField.removeTextListener(this);
            if (this.timeHasChanged) {
                this.readAndFormatTime();
            }
        }
    }
}

